#ifndef APP_H
#define APP_H

#include "Pwm.h"
#include "UartSystem.h"

enum HeatErrorStatus{
	HeatClear = 0x00,  
	HeatOverTemperture = 0x01, 
	HeatOpenCircuit = 0x02
};

// <<< Use Configuration Wizard in Context Menu >>>
//<h> Set the switch speed value
	//<o> Speed_Level_1 (unit : 10rpm)
		#define Speed_Level_1 (short) ((float) 8500 * 32767 / BASE_RPM)

	// <o> Speed_Level_2 (unit : 10rpm)
		#define Speed_Level_2 (short) ((float) 10500 * 32767 / BASE_RPM)
//</h>

//<h> Set the HEAT value
	//<o> Heat_Level_1 (unit : val) <0-1023>
		#define Heat_Level_1 (short) (500)

	//<o> Heat_Period_1 (unit : val)  
		#define Heat_Duty_1 (short) (3)

	//<o> Heat_Sin_Period_1 (unit : val)
		#define Heat_Sin_1 (short) (1)

	//<o> Heat_Level_2 (unit : val)
		#define Heat_Level_2 (short) (200)

	//<o> Heat_Period_2 (unit : val)
		#define Heat_Duty_2 (short) (2)

	//<o> Heat_Sin_Period_2 (unit : val)
		#define Heat_Sin_2 (short) (1)

	//<o> Heat_Level_Error (unit : val) <0-1023>
		#define Heat_Level_Error (short) (150)
		
	//<o> Heat_Period_Max (unit : val)
		#define Heat_Period_Max (short) (12)

	//<o> Heat_Period_Min (unit : val)
		#define Heat_Period_Min (short) (2)
//</h>

//<h> Define GPIOs
	//<o> HEAT_PIN 
		//<2=> CH2/P0_4    <3=> CH3/P0_5    <4=> CH4/P0_6 
		//<5=> CH5/P0_7    <6=> CH6/P3_2    <7=> CH7/P3_3 
		//<8=> XTALO//P3_4 <9=> XTALI//P3_5
		#define HEAT_PIN 8
		#if(HEAT_PIN==2)
			#define HEAT     	P0_4
		#elif(HEAT_PIN==3)
			#define HEAT     	P0_5
		#elif(HEAT_PIN==4)
			#define HEAT     	P0_6
		#elif(HEAT_PIN==5)
			#define HEAT     	P0_7
		#elif(HEAT_PIN==6)
			#define HEAT     	P3_2
		#elif(HEAT_PIN==7)
			#define HEAT     	P3_3
		#elif(HEAT_PIN==8)
			#define HEAT     	P3_4
		#elif(HEAT_PIN==9)
			#define HEAT     	P3_5
		#endif
		
	//<o> ZERO_PIN 
		//<2=> CH2/P0_4    <3=> CH3/P0_5    <4=> CH4/P0_6 
		//<5=> CH5/P0_7    <6=> CH6/P3_2    <7=> CH7/P3_3 
		//<8=> XTALO//P3_4 <9=> XTALI//P3_5
		#define ZERO_PIN 6
		#if(ZERO_PIN==2)
			#define ZERO     	P0_4
		#elif(ZERO_PIN==3)
			#define ZERO     	P0_5
		#elif(ZERO_PIN==4)
			#define ZERO     	P0_6
		#elif(ZERO_PIN==5)
			#define ZERO     	P0_7
		#elif(ZERO_PIN==6)
			#define ZERO     	P3_2
		#elif(ZERO_PIN==7)
			#define ZERO     	P3_3
		#elif(ZERO_PIN==8)
			#define ZERO     	P3_4
		#elif(ZERO_PIN==9)
			#define ZERO     	P3_5
		#endif
	//<o> SPEED_ZC_PIN 
		//<2=> CH2/P0_4    <3=> CH3/P0_5    <4=> CH4/P0_6 
		//<5=> CH5/P0_7    <6=> CH6/P3_2    <7=> CH7/P3_3 
		//<8=> XTALO//P3_4 <9=> XTALI//P3_5
		#define SPEED_ZC_PIN 7
		#if(SPEED_ZC_PIN==2)
			#define SPEED_ZC     	P0_4
		#elif(SPEED_ZC_PIN==3)
			#define SPEED_ZC     	P0_5
		#elif(SPEED_ZC_PIN==4)
			#define SPEED_ZC     	P0_6
		#elif(SPEED_ZC_PIN==5)
			#define SPEED_ZC     	P0_7
		#elif(SPEED_ZC_PIN==6)
			#define SPEED_ZC     	P3_2
		#elif(SPEED_ZC_PIN==7)
			#define SPEED_ZC     	P3_3
		#elif(SPEED_ZC_PIN==8)
			#define SPEED_ZC     	P3_4
		#elif(SPEED_ZC_PIN==9)
			#define SPEED_ZC     	P3_5
		#endif
	//<o> HEAT_SW_PIN 
		//<2=> CH2/P0_4    <3=> CH3/P0_5    <4=> CH4/P0_6 
		//<5=> CH5/P0_7    <6=> CH6/P3_2    <7=> CH7/P3_3 
		//<8=> XTALO//P3_4 <9=> XTALI//P3_5
		#define HEAT_SW_PIN 9
		#if(HEAT_SW_PIN==2)
			#define HEAT_SW     	P0_4
		#elif(HEAT_SW_PIN==3)
			#define HEAT_SW     	P0_5
		#elif(HEAT_SW_PIN==4)
			#define HEAT_SW     	P0_6
		#elif(HEAT_SW_PIN==5)
			#define HEAT_SW     	P0_7
		#elif(HEAT_SW_PIN==6)
			#define HEAT_SW     	P3_2
		#elif(HEAT_SW_PIN==7)
			#define HEAT_SW     	P3_3
		#elif(HEAT_SW_PIN==8)
			#define HEAT_SW     	P3_4
		#elif(HEAT_SW_PIN==9)
			#define HEAT_SW     	P3_5
		#endif
//</h>

#define HEAT_ON  0
#define HEAT_OFF 1

#define Out_max 32767////51199((25*2048)-1)//53247((26*2048)-1)
#define Out_min 0

#define Pi_kp 64//((signed int)(32767 * 0.9))
#define Pi_ki 4//((signed int)(32767 * 0.004))
//#define pi_kc 2

extern xdata unsigned int Heat_Cnt;
extern xdata unsigned int Heat_Enalbe_Cnt;
extern xdata unsigned int Heat_Level_Temperture_Cmd;
extern xdata int Pi_Out_Set;
//extern xdata int Pi_Out_Set;
//extern xdata int Pi_Err;
//extern xdata long Pi_Sum;
//extern xdata long Pi_U;
//extern xdata long Pi_Out;

#define led_a_OUTPUT PINCONG1 = PINCONG1&0x3F; PINCONG1 = PINCONG1|0x40
#define led_b_OUTPUT PINCONG6 = PINCONG6&0xfC; PINCONG6 = PINCONG6|0x01
#define led_c_OUTPUT PINCONG6 = PINCONG6&0xCF; PINCONG6 = PINCONG6|0x10

sbit led_a = P0^6;//(RED)
sbit led_b = P3^1; //(YELLOW)
sbit led_c = P2^4; //(BLUE)

extern xdata unsigned char Speed_High_Cnt;
extern xdata unsigned char Speed_Low_Cnt;
extern xdata unsigned char Speed_Level;
extern xdata unsigned char Heat_Level;
extern bit VDC_BUS_LOW_200V_F;
extern bit SW_HOT_COOL;
extern bit ZERO_Check;
extern bit ZERO_OLD;
extern xdata unsigned int HEAT_SW_Cnt;
extern xdata unsigned int ZERO_Count;
extern unsigned char Error_Status;
extern unsigned char HeatErrorState;
extern xdata int SW_HOT_Cnt;
extern xdata unsigned char SW_HOT_Cnt0;
extern xdata unsigned char led_Cnt;
extern xdata unsigned char led_th;

extern void SW_HOT_COOL_LED(void);
extern void Error_Priority(void);
extern void Brake_Motor(void);
extern void i2c_Init (void);
extern void Key_Scan (unsigned char Level);
extern void Heat_Control (void);
extern void Speed_Level_Fun (void);
extern void Heat_Level_Fun (void);
#if (Uart_Debug == 0)
extern xdata unsigned int Led_Delay_Cnt;
extern xdata unsigned int LED_F_cnt;
extern xdata unsigned int LED_S_cnt;
extern void Led_Control(unsigned char Enable,unsigned char Error_Temp);
extern void Led_Show(void);
extern void Led_Flash(unsigned char num,unsigned char cnt,unsigned int time);
#endif
//extern void Pi_Ctrl(int ref,int set);
// <<< end of configuration section >>>
#endif